"""
Run main script: functional genome wide association analysis (FGWAS) pipeline (step 3-1: Bootstrap resampling)
Usage: python ./test.py ./data/ ./result/ bstp_1.txt 50

Author: Chao Huang (chaohuang.stat@gmail.com)
Last update: 2017-10-18
"""

import sys
import time
import numpy as np
from scipy.io import loadmat
# from numpy.linalg import eig
# from scipy.stats import f
from S3_BSTP import wild_bstp

"""
installed all the libraries above
"""


def run_script(output_dir, output_file, seg_id):

    """
    Run the commandline script for FGWAS.

    :param
        output_dir (str): full path to the output folder
        output_file (str): output file name
        seg_id (scalar): segment id of SNP data (0-9)
    """

    """+++++++++++++++++++++++++++++++++++"""
    print(""" Load results from step 1 & 2 """)
    start_0 = time.time()
    data_dim_file_name = output_dir + "/temp/data_dim.mat"
    mat = loadmat(data_dim_file_name)
    data_dim = mat['data_dim']
    data_dim = np.array([int(i) for i in data_dim[0, :]])
    n, l, m, p, g, g_num = data_dim
    y_design_file_name = output_dir + "/temp/y_design.mat"
    mat = loadmat(y_design_file_name)
    y_design = mat['y_design']
    resy_design_file_name = output_dir + "/temp/resy_design.mat"
    mat = loadmat(resy_design_file_name)
    resy_design = mat['resy_design']
    efit_eta_file_name = output_dir + "/temp/efit_eta.mat"
    mat = loadmat(efit_eta_file_name)
    efit_eta = mat['efit_eta']
    inv_sig_eta_file_name = output_dir + "/temp/inv_sig_eta.mat"
    mat = loadmat(inv_sig_eta_file_name)
    inv_sig_eta = mat['inv_sig_eta']
    hat_mat_file_name = output_dir + "/temp/hat_mat.mat"
    mat = loadmat(hat_mat_file_name)
    hat_mat = mat['hat_mat']
    all_zx_mat_file_name = output_dir + "/temp/all_zx_mat.mat"
    mat = loadmat(all_zx_mat_file_name)
    all_zx_mat = mat['all_zx_mat']
    inv_q_all_zx_file_name = output_dir + "/temp/inv_q_all_zx.mat"
    mat = loadmat(inv_q_all_zx_file_name)
    inv_q_all_zx = mat['inv_q_all_zx']
    # read the image size
    # img_size_file_name = input_dir + "img_size.txt"
    # img_size = np.loadtxt(img_size_file_name)
    # img_size = np.array([int(i) for i in img_size])
    # read the image index of non-background region
    # img_idx_file_name = input_dir + "img_idx.txt"
    # img_idx = np.loadtxt(img_idx_file_name)
    # img_idx = np.array([int(i-1) for i in img_idx])
    end_0 = time.time()
    print("Elapsed time in Step 3 is ", end_0 - start_0)

    """+++++++++++++++++++++++++++++++++++"""
    print(""" Step 3. Significant locus-voxel and locus-subregion detection """)
    start_3 = time.time()
    # alpha = 1e-5
    # c_alpha = -np.log10(alpha)
    inv_q_all_zx = np.squeeze(inv_q_all_zx)
    g = inv_q_all_zx.shape[0]
    cut_points = np.linspace(0, g, num=11)
    groups = np.array([int(i) for i in cut_points])
    zx_mat = all_zx_mat[groups[int(seg_id)]:groups[int(seg_id)+1], :]
    inv_q_zx = inv_q_all_zx[groups[int(seg_id)]:groups[int(seg_id)+1]]
    l_stat_top1 = wild_bstp(zx_mat, inv_q_zx, y_design, resy_design, efit_eta, inv_sig_eta, hat_mat, g_num)
    print(l_stat_top1)
    bstp_out_file_name = output_dir + output_file
    np.savetxt(bstp_out_file_name, l_stat_top1)
    end_3 = time.time()
    print("Elapsed time in Step 3 is ", end_3 - start_3)


if __name__ == '__main__':
    output_dir0 = sys.argv[1]
    output_file0 = sys.argv[2]
    seg_id0 = sys.argv[3]
    run_script(output_dir0, output_file0, seg_id0)
